﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Configuration;
using Microsoft.Samples.ServiceHosting.StorageClient;
using System.Threading;
using System.Collections.Specialized;
using System.Reflection;
using System.IO;
using System.IO.Compression;
using System.Net;
using System.Net.Mime;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.Serialization;
using System.Collections;
using System.Xml.Serialization;
using System.Drawing.Imaging;
using ProAzureCommonLib;
namespace Windows_Azure_Storage
{
    public partial class WindowsAzureStorage : Form
    {
        private WindowsAzureStorageHelper m_StorageHelper;
        private bool m_IsLocal = false;

        public WindowsAzureStorageHelper StorageHelper
        {
            get { return m_StorageHelper; }
            set { m_StorageHelper = value; }
        }

        public bool IsLocal
        {
            get { return m_IsLocal; }
            set { m_IsLocal = value; }
        }
        public WindowsAzureStorage()
        {
            InitializeComponent();
            Init();
        }

        private void Init()
        {
            string localAccountName = ConfigurationManager.AppSettings["LocalStorageAccountName"];
            if (!string.IsNullOrEmpty(localAccountName))
            {
               string accountName = ConfigurationManager.AppSettings["AccountName"];
               string accountSharedKey = ConfigurationManager.AppSettings["AccountSharedKey"];
               txtAccountName.Text = accountName;
               txtKey.Text = accountSharedKey;

               if (!string.IsNullOrEmpty(accountName))
               {
                   if (accountName == localAccountName)
                       IsLocal = true;
               }

            }

        }

        private void LoadStorageAccount()
        {
            if (txtAccountName.Text.Length > 0 && txtKey.Text.Length > 0)
            {
                try
                {
                    statusLabel.Text = "";
                    string localAccountName = ConfigurationManager.AppSettings["LocalStorageAccountName"];

                    if (txtAccountName.Text == localAccountName)
                        IsLocal = true;


                    string blobStorageEndPoint = ConfigurationManager.AppSettings["BlobStorageEndpoint"];
                    string queueStorageEndpoint = ConfigurationManager.AppSettings["QueueStorageEndpoint"];
                    string tableStorageEndpoint = ConfigurationManager.AppSettings["TableStorageEndpoint"];

                    StorageHelper = new WindowsAzureStorageHelper(txtAccountName.Text,
                        txtKey.Text, IsLocal,
                        blobStorageEndPoint,
                        queueStorageEndpoint,
                        tableStorageEndpoint);

                    //TreeNode account = treeView1.Nodes.Add(txtAccountName.Text);
                    //treeView1.ExpandAll();


                    statusLabel.Text = "Connected successfully...";

                }
                catch (Exception ex)
                {

                    MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }//if

        }

        private void CheckConnection()
        {
            if (StorageHelper == null)
                LoadStorageAccount();

        }

        #region Blob Functions

        private void LoadContainers(object target)
        {

            try
            {
                

                if (cbGetAll.Checked)
                {
                    string[] blobContainers = StorageHelper.GetContainerNames(StorageHelper.GetContainers());

                    if (blobContainers != null)
                    {
                        if (lbContainers.InvokeRequired )
                        {
                            lbContainers.Invoke(new MethodInvoker(delegate { lbContainers.Items.AddRange(blobContainers); }));
                            statusLabel.Text = "Containers loaded successfully...";
                            
                        }
                        if (cbDestinationContainer.InvokeRequired)
                        {

                            cbDestinationContainer.Invoke(new MethodInvoker(delegate { cbDestinationContainer.Items.AddRange(blobContainers); }));

                        }
                    }
                }
                else
                {
                    string prefix = txtPrefix.Text;
                    string marker = txtMarker.Text;
                    int maxResults = 100;
                    if (!string.IsNullOrEmpty(txtMaxResults.Text))
                    {

                        maxResults = int.Parse(txtMaxResults.Text.Trim());
                    }

                    IList<BlobContainer> containers = StorageHelper.GetContainers(prefix, maxResults, ref marker);

                    if (txtMarker.InvokeRequired)
                    {
                        txtMarker.Invoke(new MethodInvoker(delegate { txtMarker.Text = marker; }));

                    }

                    if (string.IsNullOrEmpty(marker))
                    {
                        statusLabel.Text = "All Containers retrieved successfully...";
                    }
                    else
                    {

                        statusLabel.Text = "Click on List Containers to retrieve more containers....";
                    }

                    foreach (BlobContainer b in containers)
                    {
                        if (lbContainers.InvokeRequired)
                        {
                            lbContainers.Invoke(new MethodInvoker(delegate { lbContainers.Items.Add(b.ContainerName); }));
                        }
                        if (cbDestinationContainer.InvokeRequired)
                        {
                            cbDestinationContainer.Invoke(new MethodInvoker(delegate { cbDestinationContainer.Items.Add(b.ContainerName); }));


                        }

                    }

                }


            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        private void btnListContainers_Click(object sender, EventArgs e)
        {
            if (cbGetAll.Checked || string.IsNullOrEmpty(txtMarker.Text))
            {
                lbContainers.Items.Clear();
                cbDestinationContainer.Items.Clear();
            }
            CheckConnection();

           ThreadPool.QueueUserWorkItem(new WaitCallback(LoadContainers));
                 
           
            
        }

        //private void btnConnect_Click(object sender, EventArgs e)
        //{
        //    LoadStorageAccount();
        //}

        private void cbGetAll_CheckedChanged(object sender, EventArgs e)
        {
            lbContainers.Items.Clear();
            txtMarker.Text = string.Empty;
        }

        private void lbContainers_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearMetadata();
            treeView1.Nodes.Clear();
            txtContainerName.Text = lbContainers.Text;
            cbPublic.Checked = (StorageHelper.GetContainerACL(txtContainerName.Text) == ContainerAccessControl.Public);

            
            ContainerProperties containerProps = StorageHelper.GetContainerProperties(txtContainerName.Text);
            AddContainerMetadataToControls(containerProps);

        }

        private void btnContainerFunction_Click(object sender, EventArgs e)
        {
            if (txtContainerName.Text.Length > 0)
            {
                try
                {
                    CheckConnection();

                    ExecuteFunction(lbFunctions.Text);
                }
                catch (Exception ex)
                {

                    MessageBox.Show(ex.Message, "Error executing function " + lbFunctions.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);

                }

            }
            else
            {

                MessageBox.Show("Please specify a Container name...");

            }


        }

        private void ExecuteFunction(string functionName)
        {
            switch (functionName)
            {
                case "Create Container":


                    StorageHelper.CreateContainer(txtContainerName.Text,
                        ((cbPublic.Checked) ? ContainerAccessControl.Public : ContainerAccessControl.Private),
                        GetMetaDataFromControls());

                    lbContainers.Items.Clear();
                    ThreadPool.QueueUserWorkItem(new WaitCallback(LoadContainers));
                    MessageBox.Show("Container created successfully", "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);

                    break;
                case "Get Container Properties":
                    ClearMetadata();
                    ContainerProperties containerProps = StorageHelper.GetContainerProperties(txtContainerName.Text);
                    AddContainerMetadataToControls(containerProps);


                    break;
                case "Set Container Metadata":
                    if (StorageHelper.SetContainerMetadata(txtContainerName.Text, GetMetaDataFromControls()))
                    {

                        ClearMetadata();
                        ContainerProperties containerProps1 = StorageHelper.GetContainerProperties(txtContainerName.Text);
                        AddContainerMetadataToControls(containerProps1);
                        MessageBox.Show("Metadata values set successfully", "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);

                    }
                    else
                    {
                        MessageBox.Show("Metadata was not set. Please trace the message.", "Metadata not set", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
 

                    break;
                case "Get Container ACL":
                    
                    cbPublic.Checked = (StorageHelper.GetContainerACL(txtContainerName.Text) == ContainerAccessControl.Public);
                    
                    break;
                case "Set Container ACL":
                   
                    StorageHelper.SetContainerACL(txtContainerName.Text, ((cbPublic.Checked)?ContainerAccessControl.Public:ContainerAccessControl.Private));
                    cbPublic.Checked = (StorageHelper.GetContainerACL(txtContainerName.Text) == ContainerAccessControl.Public);
                    MessageBox.Show("ACL value set successfully", "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);


                    break;
                case "Delete Container":
                   DialogResult dr = MessageBox.Show(String.Format("Are you sure you want to delete Container {0}?", txtContainerName.Text),
                        "Delete Container", MessageBoxButtons.YesNo, MessageBoxIcon.Question);

                   if (dr == DialogResult.Yes)
                   {
                       if (StorageHelper.DeleteContainer(txtContainerName.Text))
                       {
                           ClearMetadata();
                           lbContainers.Items.Clear();
                           ThreadPool.QueueUserWorkItem(new WaitCallback(LoadContainers));

                           MessageBox.Show("Container deleted successfully", "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);

                       }
                       else
                       {
                           MessageBox.Show("Delete operation failed.", "Failed", MessageBoxButtons.OK, MessageBoxIcon.Error);


                       }
                   }
                   else
                   {
                       statusLabel.Text = String.Format("Delete Container {0} operation cancelled.", txtContainerName.Text);

                   }
                    break;
                case "List Blobs":

                    ListBlobs();
                    //ListBlobsStr();

                    break;
                default:
                    return;



            };
            statusLabel.Text = "Method executed successfully";

        }

        private void ListBlobs()
        {
            string prefix = txtBlobPrefix.Text;
            string marker = txtBlobMarker.Text;
            int maxResults = 100;
            if (!string.IsNullOrEmpty(txtBlobMaxResults.Text))
            {

                maxResults = int.Parse(txtBlobMaxResults.Text.Trim());
            }
            string containerName = txtContainerName.Text;

           

            treeView1.Nodes.Clear();
            TreeNode account = treeView1.Nodes.Add(txtAccountName.Text);


           
            if (account != null)
            {
                
                TreeNode container = account.Nodes.Add(txtContainerName.Text);

                ListBlobs(containerName, prefix, txtDelimiter.Text, maxResults, ref marker, container);
                treeView1.ExpandAll();

                txtBlobMarker.Text = marker;
            }
            else
            {

                MessageBox.Show("Invalid Account Name", "Invalid Account Name", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
       
        private void ListBlobs(string containerName, string blobPrefix, string delimiter, int maxResults, ref string marker, TreeNode tn)
        {

            IList<object> blobList = new List<object>(StorageHelper.ListBlobs(txtContainerName.Text, blobPrefix, delimiter, maxResults, ref marker));
            

            foreach (object o in blobList)
            {
                if (o is BlobProperties)
                {

                   BlobProperties bp = (BlobProperties)o;
                
                    string[] structureArr = bp.Name.Split(char.Parse(delimiter));

                    if (structureArr != null && structureArr.Length > 0)
                    {
                        
                        if (tn != null)
                        {
                            TreeNode t2 = tn.Nodes.Add(structureArr[structureArr.Length - 1]);
                            t2.ToolTipText = bp.Name;

                        }
                     

                    }
                    

                }
                else if (o is string)
                {
                    string bPrefix = (string)o;
                    string[] structureArr = bPrefix.Split(char.Parse(delimiter));

                    if (structureArr != null && structureArr.Length > 0)
                    {
                        string node = string.Empty;
                        TreeNode t1 = null;
                        if (structureArr.Length > 1)
                        {
                            node = structureArr[structureArr.Length - 2];
                            t1 = tn.Nodes.Add(node);
                        }
                        else
                        {
                            node = structureArr[0];
                            t1 = tn.Nodes.Add(node);
                        }
                        

                        ListBlobs(containerName, bPrefix, delimiter, maxResults, ref marker, t1);

                    }
                    


                }



            }
        }


        private void ListBlobsStr()
        {
            string prefix = txtBlobPrefix.Text;
            string marker = txtBlobMarker.Text;
            int maxResults = 100;
            if (!string.IsNullOrEmpty(txtBlobMaxResults.Text))
            {

                maxResults = int.Parse(txtBlobMaxResults.Text.Trim());
            }
            string containerName = txtContainerName.Text;


            IList<string> blobs = new List<string>();
            string basePath = string.Empty;
                ListBlobsStr(containerName, prefix, txtDelimiter.Text, maxResults, ref marker, blobs, basePath);
              

                txtBlobMarker.Text = marker;
            
           
        }

        private void ListBlobsStr(string containerName, string blobPrefix, string delimiter, int maxResults, ref string marker, IList<string> tn, string basePath)
        {

            IList<object> blobList = new List<object>(StorageHelper.ListBlobs(txtContainerName.Text, blobPrefix, delimiter, maxResults, ref marker));


            foreach (object o in blobList)
            {
                if (o is BlobProperties)
                {

                    BlobProperties bp = (BlobProperties)o;

                    string[] structureArr = bp.Name.Split(char.Parse(delimiter));

                    if (structureArr != null && structureArr.Length > 0)
                    {

                        if (tn != null)
                        {
                          tn.Add(  basePath + delimiter + (structureArr[structureArr.Length - 1]));

                        }


                    }


                }
                else if (o is string)
                {
                    string bPrefix = (string)o;
                    string[] structureArr = bPrefix.Split(char.Parse(delimiter));

                    if (structureArr != null && structureArr.Length > 0)
                    {
                        string node = string.Empty;
                        string t1 = null;
                        if (structureArr.Length > 1)
                        {
                            node = structureArr[structureArr.Length - 2];
                            t1 = node;
                        }
                        else
                        {
                            node = structureArr[0];
                            t1 = node;
                        }


                        ListBlobsStr(containerName, bPrefix, delimiter, maxResults, ref marker, tn, t1);

                    }



                }



            }
        }
        private NameValueCollection GetMetaDataFromControls()
        {
            NameValueCollection metadata = new NameValueCollection();

            for (int i = 0; i < 3; i++)
            {
                string name = string.Empty;
                string value = string.Empty;
                switch (i)
                {
                    
                    case 0:
                        name = textBox1.Text;
                        value = textBox2.Text;
                        break;
                    case 1:
                        name = textBox3.Text;
                        value = textBox4.Text;
                        break;

                    case 2:
                        name = textBox5.Text;
                        value = textBox6.Text;
                        break;

                    case 3:
                        name = textBox7.Text;
                        value = textBox8.Text;
                        break;

                    default:

                        break;


                };

                if (name.Length > 0 && value.Length > 0)
                {
                    metadata.Add(name, value);
                }


            }//for

            return metadata;

        }

        private void AddContainerMetadataToControls(ContainerProperties props)
        {
            if (props != null)
            {
                lblLastModified.Text = String.Format("Last Modified (UTC):{0},  ETag:{1}", props.LastModifiedTime.ToString("F"), props.ETag);
                lblURI.Text = props.Uri.ToString();
                NameValueCollection metadata = props.Metadata;

                if(props.Metadata != null && props.Metadata.Count > 0)
                {
                    for (int i = 0;  i < metadata.Count; i++)
                    {
                        string name = metadata.GetKey(i);
                        string value = metadata[i];
                        switch (i)
                        {

                            case 0:
                                textBox1.Text = name;
                                textBox2.Text = value;
                                break;
                            case 1:
                                textBox3.Text = name; ;
                                textBox4.Text = value;
                                break;

                            case 2:
                                textBox5.Text = name; ;
                                textBox6.Text = value;
                                break;

                            case 3:
                                textBox7.Text = name; ;
                                textBox8.Text = value;
                                break;

                            default:

                                break;


                        };

                       
                    }//for
                }//if
            }//if

        }

        private void ClearMetadata()
        {


            textBox1.Text = string.Empty;
            textBox2.Text = string.Empty;

            textBox3.Text = string.Empty;
            textBox4.Text = string.Empty;

            textBox5.Text = string.Empty;
            textBox6.Text = string.Empty;

            textBox7.Text = string.Empty;
            textBox8.Text = string.Empty;

            lblURI.Text = string.Empty;
            lblLastModified.Text = string.Empty;


        }

        private void btnClearContainerResults_Click(object sender, EventArgs e)
        {
            ClearMetadata();
            txtContainerName.Text = string.Empty;
            cbPublic.Checked = false;
            treeView1.Nodes.Clear();
        }

        private void treeView1_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            ClearBlobProperties(true);
            ClearBlobMetadata();
            if (e.Node.ToolTipText != null && e.Node.ToolTipText.Length > 0)
            {
                txtBlobName.Text = e.Node.ToolTipText;
                txtDestinationBlobName.Text = Path.GetFileNameWithoutExtension(e.Node.ToolTipText) + "-copy" + Path.GetExtension(e.Node.ToolTipText);
                GetBlobProperties(txtContainerName.Text, txtBlobName.Text);
            }
        }

        private void btnExecuteBlobFunction_Click(object sender, EventArgs e)
        {
            if ((txtContainerName.Text.Length > 0 && txtBlobName.Text.Length > 0)|| cbPutMultipleBlobs.Checked)
            {
                try
                {
                    CheckConnection();

                    
                    ExecuteBlobFunction(lbBlobFunctions.Text);
                }
                catch (Exception ex)
                {

                    MessageBox.Show(ex.Message, "Error executing function " + lbBlobFunctions.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);

                }

            }
            else
            {

                MessageBox.Show("Please select a Container name and then a Blob Name...");

            }
        }

        private void ExecuteBlobFunction(string functionName)
        {
            switch (functionName)
            {
                case "Put Blob":

                    NameValueCollection nv = GetBlobMetaDataFromControls();
                    if (cbPutMultipleBlobs.Checked)
                    {
                        string[] sp = txtBlobPath.Text.Split(';');
                        if (sp != null && sp.Length > 0)
                        {
                            
                            foreach (string s in sp)
                            {

                                if (PutBlob(txtContainerName.Text, Path.GetFileName(s),
                           s, cbOverwrite.Checked, cbCompress.Checked, nv))
                                {
                                   
                                    statusLabel.Text = String.Format("Blob {0} written to Container {1}", s, txtContainerName.Text);
                                }
                                else
                                {
                                    MessageBox.Show("Unable to write to Blob. Please try overwrite.");

                                }

                            }

                        }
                    }
                    else
                    {
                        if (PutBlob(txtContainerName.Text, txtBlobName.Text,
                            txtBlobPath.Text, cbOverwrite.Checked, cbCompress.Checked, nv))
                        {
                            ClearBlobProperties(false);
                            ClearBlobMetadata();
                            GetBlobProperties(txtContainerName.Text, txtBlobName.Text);
                            statusLabel.Text = String.Format("Blob {0} written to Container {1}", txtBlobName.Text, txtContainerName.Text);
                        }
                        else
                        {
                            MessageBox.Show("Unable to write to Blob. Please try overwrite.");

                        }
                    }
                    break;
                case "Get Blob":

                    BlobContents blobContents;
                    BlobProperties props = GetBlob(txtContainerName.Text, txtBlobName.Text, true, out blobContents);
                    SaveBlobLocally(props, blobContents);

                    break;
                case "Get Blob Properties":
                    if (txtContainerName.Text.Length > 0 && txtBlobName.Text.Length > 0)
                    {
                        GetBlobProperties(txtContainerName.Text, txtBlobName.Text);
                    }
                    else
                    {

                        MessageBox.Show("Please enter a Container Name and Choose a Blob");

                    }

                    break;
              
                case "Set Blob Metadata":

                    SetBlobMetaData(txtContainerName.Text, txtBlobName.Text);
                    break;
                case "Get Block List":
                    
                    break;
                case "Delete Blob":
                    DialogResult dr = MessageBox.Show(String.Format("Are you sure you want to delete Blob {0}?", txtBlobName.Text),
                         "Delete Blob", MessageBoxButtons.YesNo, MessageBoxIcon.Question);

                    if (dr == DialogResult.Yes)
                    {
                        StorageHelper.DeleteBlob(txtContainerName.Text, txtBlobName.Text);
                        statusLabel.Text = String.Format("Blob {0} deleted successfully", txtBlobName.Text);

                        ClearMetadata();
                        treeView1.Nodes.Clear();
                        ListBlobs();

                    }
                    else
                    {
                        statusLabel.Text = String.Format("Delete Blob {0} operation cancelled.", txtBlobName.Text);

                    }
                    break;
                case "Copy Blob":

                    string destinationContainerName = txtContainerName.Text;

                    if (cbDestinationContainer.Text != null && cbDestinationContainer.Text.Length > 0)
                        destinationContainerName = cbDestinationContainer.Text;

                    if (CopyBlob(txtAccountName.Text, txtContainerName.Text, txtBlobName.Text, destinationContainerName, txtDestinationBlobName.Text))
                    {
                        statusLabel.Text = String.Format("Blob {0} copied to Blob {1} successfully", txtBlobName.Text, txtDestinationBlobName.Text);
                    }
                    else
                    {
                        MessageBox.Show(String.Format("Could not copy Blob {0}  to Blob {1}.", txtBlobName.Text, txtDestinationBlobName.Text), "Error Copying",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);

                    }
                  
                    break;
                default:
                    return;



            };
            

        }

        private void GetBlobProperties(string containerName, string blobName)
        {


            BlobProperties bp = StorageHelper.GetBlobProperties(containerName, blobName);

            txtBlobName.Text = blobName;
            txtContentEncoding.Text = bp.ContentEncoding;
            txtContentLanguage.Text = bp.ContentLanguage;
            txtContentLength.Text = bp.ContentLength.ToString();
            txtContentType.Text = bp.ContentType;
            txtETag.Text = bp.ETag;
            txtLastModified.Text = bp.LastModifiedTime.ToString("F");
            txtURI.Text = bp.Uri.ToString();

            AddBlobMetadataToControls(bp.Metadata);

           

        }

        private void AddBlobMetadataToControls(NameValueCollection metadata)
        {
            if (metadata != null && metadata.Count > 0)
            {
                for (int i = 0; i < metadata.Count; i++)
                {
                    string name = metadata.GetKey(i);
                    string value = metadata[i];
                    switch (i)
                    {

                        case 0:
                            textBox9.Text = name;
                            textBox10.Text = value;
                            break;
                        case 1:
                            textBox11.Text = name; ;
                            textBox12.Text = value;
                            break;

                        case 2:
                            textBox13.Text = name; ;
                            textBox14.Text = value;
                            break;

                        case 3:
                            textBox15.Text = name; ;
                            textBox16.Text = value;
                            break;
                        case 4:
                            textBox17.Text = name; ;
                            textBox18.Text = value;
                            break;
                        case 5:
                            textBox19.Text = name; ;
                            textBox20.Text = value;
                            break;
                       

                        default:

                            break;


                    };


                }//for
            }//if
        }

        private NameValueCollection GetBlobMetaDataFromControls()
        {
            NameValueCollection metadata = new NameValueCollection();

            for (int i = 0; i < 6; i++)
            {
                string name = string.Empty;
                string value = string.Empty;
                switch (i)
                {

                    case 0:
                        name = textBox9.Text;
                        value = textBox10.Text;
                        break;
                    case 1:
                        name = textBox11.Text;
                        value = textBox12.Text;
                        break;

                    case 2:
                        name = textBox13.Text;
                        value = textBox14.Text;
                        break;

                    case 3:
                        name = textBox15.Text;
                        value = textBox16.Text;
                        break;
                    case 4:
                        name = textBox17.Text;
                        value = textBox18.Text;
                        break;
                    case 5:
                        name = textBox19.Text;
                        value = textBox20.Text;
                        break;
                   

                    default:

                        break;


                };

                if (name.Length > 0 && value.Length > 0)
                {
                    metadata.Add(name, value);
                }


            }//for

            return metadata;

        }

        private void ClearBlobProperties(bool clearBlobName)
        {
            if (clearBlobName)
            {
                txtBlobName.Text = string.Empty;
            }
            txtContentEncoding.Text = string.Empty;
            txtContentLanguage.Text = string.Empty;
            txtContentLength.Text = string.Empty;
            txtContentType.Text = string.Empty;
            txtETag.Text = string.Empty;
            txtLastModified.Text = string.Empty;
            txtURI.Text = string.Empty;


        }
        private void ClearBlobMetadata()
        {


            textBox9.Text = string.Empty;
            textBox10.Text = string.Empty;

            textBox11.Text = string.Empty;
            textBox12.Text = string.Empty;

            textBox13.Text = string.Empty;
            textBox14.Text = string.Empty;

            textBox15.Text = string.Empty;
            textBox16.Text = string.Empty;

            textBox17.Text = string.Empty;
            textBox18.Text = string.Empty;

            textBox19.Text = string.Empty;
            textBox20.Text = string.Empty;

          

        }

        private bool PutBlob(string containerName, string blobName, string fileName, bool overwrite, bool gZipCompression, NameValueCollection metadata)
        {

         BlobProperties blobProperties = new BlobProperties(blobName);
         blobProperties.ContentType = WindowsAzureStorageHelper.GetContentTypeFromExtension(Path.GetExtension(fileName));
         blobProperties.Metadata = metadata;


         BlobContents blobContents = null;
         bool ret = false;

         
         using (FileStream fs = File.OpenRead(fileName))
         {
          blobContents = new BlobContents(fs);
         ret =  StorageHelper.CreateBlob(containerName, blobProperties, blobContents, overwrite);

         }



         return ret;

        }

        private BlobProperties GetBlob(string containerName, string blobName, bool transferAsChunks, out BlobContents blobContents)
        {
           
            blobContents = new BlobContents(new MemoryStream());
            return StorageHelper.GetBlob(containerName, blobName, blobContents, transferAsChunks);
            

        }

        private void SaveBlobLocally(BlobProperties blobProperties, BlobContents blobContents)
        {
            if (blobContents != null && blobContents.AsBytes() != null && blobContents.AsBytes().Length > 0)
            {
                SaveFileDialog save = new SaveFileDialog();
                save.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
                save.Filter = "All files (*.*)|*.*"  ;
                if (blobProperties.Name.Contains<char>('/'))
                {
                    save.FileName = blobProperties.Name.Substring(blobProperties.Name.LastIndexOf('/') + 1);
                }
                else
                {
                    save.FileName = blobProperties.Name;
                }

               
                DialogResult dr = save.ShowDialog();
                if (dr == DialogResult.OK)
                {
                   

                    File.WriteAllBytes(save.FileName, blobContents.AsBytes());

                    statusLabel.Text = String.Format("Blob {0} written to File {1}.", blobProperties.Name, save.FileName);

                }//if
            }//if
            else
            {

                MessageBox.Show("The retrieved contents were blank");

            }

            
        }
       
        private void btnFileBrowse_Click(object sender, EventArgs e)
        {
            DialogResult dr = openFileDialog1.ShowDialog();

            
            if (dr == DialogResult.OK)
            {
                ClearBlobProperties(true);

                if (openFileDialog1.FileNames.Length > 1)
                {
                    cbPutMultipleBlobs.Checked = true;
                    txtBlobPath.Text = "";
                    foreach (string s in openFileDialog1.FileNames)
                    {
                        txtBlobPath.Text += s +";";

                    }
                    txtBlobPath.Text = txtBlobPath.Text.Remove(txtBlobPath.Text.LastIndexOf(';'));
                }
                else
                {
                    cbPutMultipleBlobs.Checked = false;
                    txtBlobPath.Text = openFileDialog1.FileName;
                    txtBlobName.Text = openFileDialog1.SafeFileName;
                }
         

            }
        }


        private void SetBlobMetaData(string containerName, string blobName)
        {
            BlobProperties props = StorageHelper.GetBlobProperties(containerName, blobName);

            if (props != null)
            {
                props.Metadata = GetBlobMetaDataFromControls();

                StorageHelper.UpdateBlobMetadata(containerName, props);

                props = StorageHelper.GetBlobProperties(containerName, blobName);

                AddBlobMetadataToControls(props.Metadata);

            }

            
        }

        private bool CopyBlob(string accountName, string sourceContainerName, string blobName, string destinationContainerName, string destinationBlobName)
        {
            BlobProperties sourceBlobProperties = StorageHelper.GetBlobProperties(sourceContainerName, blobName);
            sourceBlobProperties.Metadata = GetMetaDataFromControls();
            blobName = String.Format("/{0}/{1}/{2}", accountName, sourceContainerName, blobName);
            return StorageHelper.CopyBlob(destinationContainerName, sourceBlobProperties, blobName, destinationBlobName, "2009-04-14");

        }
        #endregion

        #region Queue Functions

        private void btnExecuteQueueFunction_Click(object sender, EventArgs e)
        {
            if (txtQueueName.Text.Length > 0 )
            {
                try
                {
                    CheckConnection();


                    ExecuteQueueFunction(lbQueueFunctions.Text);
                    statusLabel.Text = String.Format("Operation {0} executed successfully.", lbQueueFunctions.Text);
                }
                catch (Exception ex)
                {

                    MessageBox.Show(ex.Message, "Error executing function " + lbQueueFunctions.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);

                }

            }
            else
            {

                MessageBox.Show("Please select a Queue name...");

            }
           
        }

        private void btnListQueues_Click(object sender, EventArgs e)
        {
            try
            {
                ListQueues();
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.StackTrace, ex.Message, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
          

        }

        private void ListQueues()
        {
            
            CheckConnection();
            lbQueues.Items.Clear();
            IList<MessageQueue> queues = new List<MessageQueue>(StorageHelper.ListQueues(txtlistQueuePrefix.Text));
            foreach (MessageQueue mq in queues)
            {
                lbQueues.Items.Add(mq.Name);

            }

        }

      

        private void ExecuteQueueFunction(string functionName)
        {
            switch (functionName)
            {
                case "Create Queue":
                    bool alreadyExists;
                    if (StorageHelper.CreateQueue(txtQueueName.Text, out alreadyExists))
                    {

                        ListQueues();
                        MessageBox.Show(String.Format("Queue {0} created successfully.", txtQueueName.Text));
                    }

                    else
                    {
                        MessageBox.Show("Unable to create queue. Already exists?" + alreadyExists);

                    }
                    break;
                case "Delete Queue":

                    if (StorageHelper.DeleteQueue(txtQueueName.Text))
                    {

                        ListQueues();

                    }
                    else
                    {
                        MessageBox.Show(String.Format("Unable to delete queue {0}.", txtQueueName.Text));

                    }
                    break;
               
                case "Get Queue Metadata":

                    GetQueueProperties();
                    break;
                case "Set Queue Metadata":
                    SetQueueProperties();
                    break;
                case "Get Messages":
                    GetMessages();
                    break;
                case "Put Message":
                    PutMessage();
                    break;
                case "Clear Messages":
                    ClearMessages();
                    break;
                case "Peek Messages":
                    PeekMessages();
                    break;
                case "Delete Message":
                    MessageBox.Show("Please select a message from the Message Grid and hit the Delete button on your keyboard to delete the message");
                    break;
                default:
                    return;



            };


        }

        private void GetQueueProperties()
        {
            QueueProperties qrp = StorageHelper.GetQueueProperties(txtQueueName.Text);

            AddQueueMetadataToControls(qrp.Metadata);

        }

        private void SetQueueProperties()
        {
            QueueProperties qrp = new QueueProperties();
            qrp.Metadata = GetQueueMetaDataFromControls();
            
            if (StorageHelper.SetQueueProperties(txtQueueName.Text, qrp))
            {

                MessageBox.Show("Queue properties set succesfully.");
            }
            else
            {
                MessageBox.Show("Unable to set Queue properties.");

            }

        }
        private void AddQueueMetadataToControls(NameValueCollection metadata)
        {
            if (metadata != null && metadata.Count > 0)
            {
                for (int i = 0; i < metadata.Count; i++)
                {
                    string name = metadata.GetKey(i);
                    string value = metadata[i];
                    switch (i)
                    {

                        case 0:
                            txtQM1.Text = name;
                            txtQM2.Text = value;
                            break;
                        case 1:
                            txtQM3.Text = name; ;
                            txtQM4.Text = value;
                            break;

                        case 2:
                            txtQM5.Text = name; ;
                            txtQM6.Text = value;
                            break;

                        case 3:
                            txtQM7.Text = name; ;
                            txtQM8.Text = value;
                            break;
                     

                        default:

                            break;


                    };


                }//for
            }//if
        }

        private NameValueCollection GetQueueMetaDataFromControls()
        {
            NameValueCollection metadata = new NameValueCollection();

            for (int i = 0; i < 6; i++)
            {
                string name = string.Empty;
                string value = string.Empty;
                switch (i)
                {

                    case 0:
                        name = txtQM1.Text;
                        value = txtQM2.Text;
                        break;
                    case 1:
                        name = txtQM3.Text;
                        value = txtQM4.Text;
                        break;

                    case 2:
                        name = txtQM5.Text;
                        value = txtQM6.Text;
                        break;

                    case 3:
                        name = txtQM7.Text;
                        value = txtQM8.Text;
                        break;
                   

                    default:

                        break;


                };

                if (name.Length > 0 && value.Length > 0)
                {
                    metadata.Add(name, value);
                }


            }//for

            return metadata;

        }

        private void lbQueues_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearQueueMetadata();
            txtQueueName.Text = lbQueues.Text;
            MessageQueue queue = StorageHelper.GetQueue(txtQueueName.Text);
            QueueProperties queueProps = StorageHelper.GetQueueProperties(txtQueueName.Text);
            AddQueueMetadataToControls(queueProps.Metadata);
            lblQueueURI.Text = queue.QueueUri.ToString();
           
            
        }

        private void ClearQueueMetadata()
        {


            txtQM1.Text = string.Empty;
            txtQM2.Text = string.Empty;

            txtQM3.Text = string.Empty;
            txtQM4.Text = string.Empty;

            txtQM5.Text = string.Empty;
            txtQM6.Text = string.Empty;

            txtQM7.Text = string.Empty;
            txtQM8.Text = string.Empty;

            lblURI.Text = string.Empty;
            lblLastModified.Text = string.Empty;


        }

        private void btnClearQueueResults_Click(object sender, EventArgs e)
        {
            ClearQueueMetadata();
            txtQueueName.Text = string.Empty;
            dgvMessages.Rows.Clear();
        
        }

        private void GetMessages()
        {
           dgvMessages.Rows.Clear();
            IEnumerable<Microsoft.Samples.ServiceHosting.StorageClient.Message> msgs = StorageHelper.GetMessages(txtQueueName.Text, int.Parse(txtNumberOfMessages.Text), int.Parse(txtVisibilityTimeoutSecs.Text));

            if (msgs != null)
            {
                IList<Microsoft.Samples.ServiceHosting.StorageClient.Message> messages = new List<Microsoft.Samples.ServiceHosting.StorageClient.Message>(msgs);
                PopulateMessagesDataGridView(messages);

            }


        }

        private void PeekMessages()
        {
         dgvMessages.Rows.Clear();
         IEnumerable<Microsoft.Samples.ServiceHosting.StorageClient.Message> msgs = StorageHelper.PeekMessages(txtQueueName.Text, int.Parse(txtNumberOfMessages.Text));
         if (msgs != null)
         {
          IList<Microsoft.Samples.ServiceHosting.StorageClient.Message> messages = new List<Microsoft.Samples.ServiceHosting.StorageClient.Message>(msgs);
          PopulateMessagesDataGridView(messages);

         }

        }

        private void PopulateMessagesDataGridView(IList<Microsoft.Samples.ServiceHosting.StorageClient.Message> messages)
        {
            foreach (Microsoft.Samples.ServiceHosting.StorageClient.Message m in messages)
            {
                string[] row = new string[6];
                row[0] = m.Id;
                row[1] = m.ContentAsString();
                row[2] = m.InsertionTime.ToString("F");
                row[3] = m.ExpirationTime.ToString("F");
                row[4] = m.PopReceipt;
                row[5] = m.TimeNextVisible.ToString("F");
                //if (dgvMessages.InvokeRequired)
                //{
                //    dgvMessages.Invoke(new MethodInvoker(delegate { dgvMessages.Rows.Add(row); }));
                //}
                dgvMessages.Rows.Add(row);
            }

        }

        private void PopulateSingleMessageDataGridView(object message)
        {
         
            Microsoft.Samples.ServiceHosting.StorageClient.Message m = message as Microsoft.Samples.ServiceHosting.StorageClient.Message;
            if (m != null)
            {
                string[] row = new string[6];
                row[0] = m.Id;
                row[1] = m.ContentAsString();
                row[2] = m.InsertionTime.ToString("F");
                row[3] = m.ExpirationTime.ToString("F");
                row[4] = m.PopReceipt;
                row[5] = m.TimeNextVisible.ToString("F");

                if (dgvMessages.InvokeRequired)
                {
                    dgvMessages.Invoke(new MethodInvoker(delegate { dgvMessages.Rows.Add(row); }));


                }
            }

        }

        private void PutMessage()
        {
            string messageBody = string.Empty;
            if (txtMessageBody.Text.Length > 0)
            {
                messageBody = txtMessageBody.Text;

            }
            else
            {
                messageBody = String.Format("Message from Windows Azure Storage Operations", System.Guid.NewGuid().ToString("N"));
            }
            int ttlsecs = 300;
            if(txtTimeTolive.Text.Length > 0)
            {
                ttlsecs = int.Parse(txtTimeTolive.Text);
            }
            if (StorageHelper.PutMessage(txtQueueName.Text, new Microsoft.Samples.ServiceHosting.StorageClient.Message(messageBody), ttlsecs))
            {
                statusLabel.Text = String.Format("Message {0} sent successfully to queue {1}", messageBody, txtQueueName.Text);

            }
            
        }

        private void ClearMessages()
        {
         StorageHelper.ClearMessages(txtQueueName.Text);
         dgvMessages.Rows.Clear();

        }

        private bool DeleteMessage(string queueName, string messageContent, string messageId, string popReceipt)
        {
         Microsoft.Samples.ServiceHosting.StorageClient.Message msg = new Microsoft.Samples.ServiceHosting.StorageClient.Message(messageContent);
         msg.Id = messageId;
         msg.PopReceipt = popReceipt;
         return StorageHelper.DeleteMessage(queueName, msg);
        }
        

        private void dgvMessages_UserDeletedRow(object sender, DataGridViewRowEventArgs e)
        {
         
         string messageId = e.Row.Cells[0].Value.ToString();
         string messageBody = e.Row.Cells[1].Value.ToString();
         string popReceipt = e.Row.Cells[4].Value.ToString();

         if (DeleteMessage(txtQueueName.Text, messageBody, messageId, popReceipt))
         {
          MessageBox.Show(String.Format("Message {0} deleted successfully.", messageId));

         }
         else
         {
          MessageBox.Show(String.Format("Cound not delete Message {0}.", messageId));

         }
         
        }

        private void cbStartReceivingMessages_CheckedChanged(object sender, EventArgs e)
        {

            if (txtQueueName.Text.Length > 0)
            {
                Microsoft.Samples.ServiceHosting.StorageClient.MessageQueue mq = StorageHelper.GetQueue(txtQueueName.Text);

                if (cbStartReceivingMessages.Checked)
                {

                    mq.MessageReceived += new MessageReceivedEventHandler(mq_MessageReceived);
                    mq.PollInterval = 10000;
                    if (mq.StartReceiving())
                    {
                        statusLabel.Text = "Automatic Message receiving started...";

                    }
                    else
                    {
                        statusLabel.Text = "Could not start automatic Message receiving...";
                    }

                }
                else
                {
                    mq.StopReceiving();
                    mq.MessageReceived -= new MessageReceivedEventHandler(mq_MessageReceived);


                }
            }//if
            else
            {
                MessageBox.Show("Please select a Queue.");

            }
        }

        void mq_MessageReceived(object sender, MessageReceivedEventArgs e)
        {
            ThreadPool.QueueUserWorkItem(new WaitCallback(PopulateSingleMessageDataGridView), e.Message);
         
        }

        #endregion

        private void dgvMessages_UserDeletingRow(object sender, DataGridViewRowCancelEventArgs e)
        {

        }

       

        private void btnSendQueueMessage3P_Click(object sender, EventArgs e)
        {
         try
         {
        //  SendQueueMessage3P(txtContainerName3P.Text, txtBlobName3P.Text, txtCorrId.Text);

         }
         catch (Exception ex)
         {
          MessageBox.Show(ex.Message, "Error sending queue message", MessageBoxButtons.OK, MessageBoxIcon.Error);

         }
        }

        private void SendQueueMessage3P(string containerName, string blobFileName, string correlationId)
        {

          string queueName = ConfigurationManager.AppSettings["inputfilequeuename"];
          CheckConnection();
          bool alreadyExists;
          StorageHelper.CreateQueue(queueName, out alreadyExists);
         
          string messageBody = String.Format("{0}:{1}:{2}", correlationId, containerName, blobFileName);
          int ttlsecs = 300;

          if (StorageHelper.PutMessage(queueName, new Microsoft.Samples.ServiceHosting.StorageClient.Message(messageBody), ttlsecs))
          {
           this.statusLabel.Text = String.Format("Message {0} sent successfully to queue {1}", messageBody, queueName);

          }

        }

      
    
    }
}
